<?php
/**
 * Cerrar sesión de usuario
 * Sistema de Parking - Viewnext
 */

// Iniciar sesión para poder destruirla
session_start();

// Log de logout (opcional)
if (isset($_SESSION['usuario_email'])) {
    error_log("Usuario " . $_SESSION['usuario_email'] . " cerró sesión en " . date('Y-m-d H:i:s'));
}

// Destruir todas las variables de sesión
$_SESSION = array();

// Si se desea destruir la sesión completamente, también hay que borrar la cookie de sesión
// Nota: Esto destruirá la sesión, no solo los datos de sesión
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finalmente, destruir la sesión
session_destroy();

// Redirigir al login con mensaje de logout exitoso
header('Location: login_register.html?logout=success');
exit();
?>