<?php
session_start();
header('Content-Type: application/json');

// Activar errores para depuración
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar si el usuario está logueado
if (!isset($_SESSION['usuario_logueado']) || $_SESSION['usuario_logueado'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Usuario no autenticado']);
    exit();
}

// Incluir conexión a base de datos
require_once 'conexion.php';

try {
    // Obtener datos JSON del request
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Datos de entrada inválidos');
    }
    
    $fecha = $input['fecha'] ?? 'hoy';
    $hora = $input['hora'] ?? '08:00';
    $usuario_id = $_SESSION['usuario_id'];
    
    $fecha_consulta = ($fecha === 'hoy') ? date('Y-m-d') : date('Y-m-d', strtotime('+1 day'));
    $hora_fin = date('H:i:s', strtotime($hora . ' +30 minutes'));
    $hora_inicio = $hora . ':00';

    // Obtener todas las plazas reservables
    $stmt = $conexion->prepare("SELECT id, numero, tipo, reservable FROM plazas WHERE reservable = 1 ORDER BY posicion_y, posicion_x");
    $stmt->execute();
    $result = $stmt->get_result();
    $plazas = $result->fetch_all(MYSQLI_ASSOC);

    $plazasConEstado = [];

    foreach ($plazas as $plaza) {
        $stmt2 = $conexion->prepare("
            SELECT COUNT(*) as ocupada
            FROM reservas 
            WHERE plaza_id = ? 
            AND fecha_reserva = ? 
            AND estado = 'activa'
            AND (
                (hora_inicio <= ? AND hora_fin > ?) OR
                (hora_inicio < ? AND hora_fin >= ?) OR
                (hora_inicio >= ? AND hora_inicio < ?)
            )
        ");
        $stmt2->bind_param("isssssss",
            $plaza['id'], $fecha_consulta,
            $hora_inicio, $hora_inicio,
            $hora_fin, $hora_fin,
            $hora_inicio, $hora_fin
        );
        $stmt2->execute();
        $res = $stmt2->get_result();
        $resultado = $res->fetch_assoc();

        $plazasConEstado[] = [
            'id' => (int)$plaza['id'],
            'numero' => $plaza['numero'],
            'tipo' => $plaza['tipo'],
            'ocupada' => $resultado['ocupada'] > 0
        ];
    }

    // Obtener mis reservas
    $stmt3 = $conexion->prepare("
        SELECT r.plaza_id, p.numero as plaza_numero, p.tipo as plaza_tipo
        FROM reservas r
        JOIN plazas p ON r.plaza_id = p.id
        WHERE r.usuario_id = ? 
        AND r.fecha_reserva = ? 
        AND r.estado = 'activa'
        AND (
            (r.hora_inicio <= ? AND r.hora_fin > ?) OR
            (r.hora_inicio < ? AND r.hora_fin >= ?) OR
            (r.hora_inicio >= ? AND r.hora_inicio < ?)
        )
    ");
    $stmt3->bind_param("isssssss",
        $usuario_id,
        $fecha_consulta,
        $hora_inicio, $hora_inicio,
        $hora_fin, $hora_fin,
        $hora_inicio, $hora_fin
    );
    $stmt3->execute();
    $res2 = $stmt3->get_result();
    $misReservas = [];

    while ($row = $res2->fetch_assoc()) {
        $row['plaza_id'] = (int)$row['plaza_id'];
        $misReservas[] = $row;
    }

    echo json_encode([
        'success' => true,
        'plazas' => $plazasConEstado,
        'misReservas' => $misReservas,
        'fecha_consulta' => $fecha_consulta,
        'hora_consulta' => $hora_inicio
    ]);

} catch (Exception $e) {
    error_log("Error en consultar_disponibilidad.php: " . $e->getMessage());
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
}
?>
